<?php
if (php_sapi_name() != "cli") {
    print "This example script is written to run under the command line ('cli') version of\n";
    print "the PHP interpreter, but you're using the '".php_sapi_name()."' version\n";
    exit(1);
}

include "xapian.php";

if ($argc != 2) {
    print "Usage: {$argv[0]} PATH_TO_DATABASE\n";
    exit(1);
}

try {
    // Open the database for update, creating a new database if necessary.
    $database = new XapianWritableDatabase($argv[1], Xapian::DB_CREATE_OR_OVERWRITE);

    // add a document with a term and a timestamp value
    $doc = new XapianDocument();
    $doc->add_term("foo");
    $doc->add_value(1, Xapian::sortable_serialise(1000000000));
    $database->add_document($doc);

    // add another: same term, different timestamp value
    $doc = new XapianDocument();
    $doc->add_term("foo");
    $doc->add_value(1, Xapian::sortable_serialise(2000000000));
    $database->add_document($doc);

    // Set the database handle to Null to ensure that it gets closed
    // down cleanly or unflushed changes may be lost.
    $database = Null;

    // open database for reading
    $database = new XapianDatabase($argv[1]);
    $enquire = new XapianEnquire($database);

    // example 1 using a query processor
    $qp = new XapianQueryParser();
    $qp->set_database($database);
    $datenumproc = new XapianNumberValueRangeProcessor(1);
    $qp->add_valuerangeprocessor($datenumproc);

    // without range: get both docs
    $query = $qp->parse_query("foo");
    $enquire->set_query($query);
    print $enquire->get_mset(0, 10)->size();
    print "\n";

    // with range: get first doc
    $query = $qp->parse_query("foo 1000000000..1500000000");
    $enquire->set_query($query);
    print $enquire->get_mset(0, 10)->size();
    print "\n";

    // example 2 - direct query construction (get first doc)
    $query = new XapianQuery(XapianQuery::OP_VALUE_RANGE, 
                             1,
                             Xapian::sortable_serialise(1000000000),
                             Xapian::sortable_serialise(1500000000));
    $enquire->set_query($query);
    print $enquire->get_mset(0, 10)->size();
    print "\n";

} catch (Exception $e) {
    print $e->getMessage() . "\n";
    exit(1);
}
?>
