#
# spec file for package xapian-core (Version 1.0.6)
#

%include Solaris.inc

%define	src_name xapian-core
%define	src_url	http://www.oligarchy.co.uk/xapian/1.0.2

Name:           xapian-core
Version:        1.0.6
Release:        1
License:        GPL
Group:          Productivity/Databases/Servers
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
# BuildRequires:  gcc-c++ zlib-devel
Requires:       %{name}-libs = %{version}
#
Url:            http://www.xapian.org/
Source:         http://www.oligarchy.co.uk/xapian/%{version}/%{name}-%{version}.tar.gz
#
Summary:        The Xapian Probabilistic Information Retrieval Library.
%include default-depend.inc
SUNW_BaseDir:   %{_basedir}

%description
Xapian is an Open Source Probabilistic Information Retrieval Library. It
offers a highly adaptable toolkit that allows developers to easily add advanced
indexing and search facilities to applications.

%package devel
Summary:                 %{summary} - development files
SUNW_BaseDir:            %{_basedir}
%include default-depend.inc
Requires: %name

%prep
%setup

%build
CPUS=`/usr/sbin/psrinfo | grep on-line | wc -l | tr -d ' '`
if test "x$CPUS" = "x" -o $CPUS = 0; then
     CPUS=1
fi

PATH=/opt/SUNWspro/bin:/usr/ccs/bin:/usr/sbin:/usr/bin; export PATH
CC=cc; export CC
CXX=CC; export CXX
CFLAGS="%optflags"; export CFLAGS
CXXFLAGS="%cxx_optflags"; export CXXFLAGS
LDFLAGS="%_ldflags -lm"; export LDFLAGS

# aclocal
# libtoolize --copy --force 
# automake -a -f
# autoconf -f 
./configure --prefix=%{_prefix}			\
            --bindir=%{_bindir}			\
            --libdir=%{_libdir}			\
            --sysconfdir=%{_sysconfdir}		\
            --includedir=%{_includedir} 	\
            --mandir=%{_mandir}			\
	    --infodir=%{_infodir}		\
	    --disable-static			\
            --docdir=%{_docdir}/%{name}/        \
            --without-gcc                       \
	    --enable-shared

# make -j$CPUS
make

%install
%{__rm} -rf $RPM_BUILD_ROOT
%makeinstall CC=cc CXX=CC DESTDIR=$RPM_BUILD_ROOT docdatadir=%{_docdir}/%{name}
%{__rm} -rf examples/{.libs,.deps}
%{__cp} -pr \
    AUTHORS COPYING ChangeLog ChangeLog.examples \
    HACKING INSTALL NEWS PLATFORMS README examples \
    %{buildroot}%{_docdir}/%{name}/

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%clean
%{?pkgbuild_postprocess: %pkgbuild_postprocess -v -c "%{version}:%{jds_version}:%{name}:$RPM_ARCH:%(date +%%Y-%%m-%%d):%{support_level}" $RPM_BUILD_ROOT}

%{__rm} -rf %{buildroot}


%files
%defattr (-, root, bin)
%{_bindir}
%{_libdir}
%dir %attr (0755, root, sys) %{_datadir}
%dir %attr (0755, root, other) %{_datadir}/doc
%{_datadir}/doc/*
%{_mandir}
# %files
# %defattr(-, root, root)
# %{_bindir}/xapian-tcpsrv
# %{_bindir}/xapian-progsrv
# %{_bindir}/quartzcheck
# %{_bindir}/quartzcompact
# %{_bindir}/quartzdump
# %{_bindir}/quest
# %{_bindir}/delve
# %{_bindir}/copydatabase
# %{_bindir}/simpleindex
# %{_bindir}/simplesearch
# %{_bindir}/simpleexpand
# %{_bindir}/xapian-compact
# %{_bindir}/xapian-check
# %{_mandir}/man1/xapian-check.1*
# %{_mandir}/man1/copydatabase.1*
# %{_mandir}/man1/delve.1*
# %{_mandir}/man1/quartzcheck.1*
# %{_mandir}/man1/quartzcompact.1*
# %{_mandir}/man1/quartzdump.1*
# %{_mandir}/man1/quest.1*
# %{_mandir}/man1/xapian-compact.1*
# %{_mandir}/man1/xapian-config.1*
# %{_mandir}/man1/xapian-progsrv.1*
# %{_mandir}/man1/xapian-tcpsrv.1*
%doc %{_docdir}/%{name}/AUTHORS
%doc %{_docdir}/%{name}/COPYING
%doc %{_docdir}/%{name}/ChangeLog
%doc %{_docdir}/%{name}/ChangeLog.examples
%doc %{_docdir}/%{name}/HACKING
%doc %{_docdir}/%{name}/INSTALL
%doc %{_docdir}/%{name}/NEWS
%doc %{_docdir}/%{name}/PLATFORMS
%doc %{_docdir}/%{name}/README
# %{_libdir}/libxapian.so.*
# %{_bindir}/xapian-config
# %{_includedir}/xapian
# %{_includedir}/xapian.h
# %{_libdir}/libxapian.so
# %{_libdir}/libxapian.a
# %{_libdir}/libxapian.la
# %{_datadir}/aclocal/xapian.m4
%doc %{_docdir}/%{name}/*.html
%doc %{_docdir}/%{name}/apidoc*
%doc %{_docdir}/%{name}/examples/

%files devel
%defattr (-, root, bin)
%{_includedir}
%dir %attr (0755, root, sys) %{_datadir}
%dir %attr (0755, root, other) %{_datadir}/aclocal
%{_datadir}/aclocal/*

%changelog
* Wed Mar 19 2007 andreas.floeter@airbus.com
- update to 1.0.6 and adaption to pkgbuild and Solaris 9
* Sun Jun 24 2007 mrueckert@suse.de
- update to 1.0.1
* Sun Apr  1 2007 mrueckert@suse.de
- update to 0.9.10
* Sat Nov 11 2006 mrueckert@suse.de
- update to 0.9.9:
  many smaller changes
* Sat Nov  4 2006 mrueckert@suse.de
- do not package .deps and .libs in the examples dir
* Sat Nov  4 2006 mrueckert@suse.de
- update to 0.9.8:
  many small fixes
