<?
	/* FROM phpinfo()
	* xapian
	*
	* Xapian Support => enabled
	* Xapian Compiled Version => 0.9.6
	*/
	
	// set up a search db
	$index_path = "xapian_db";
	$index_pointer = new_WritableDatabase($index_path, DB_CREATE_OR_OPEN);
	
	$document_pointer = new_document();
	
	// add some documents with different values on the 0:th position
	$number_to_add = 5;
	for ($i = 1; $i <= $number_to_add; $i++)
	{
		$document_pointer = new_document();
		
		// add a random value in position 0
		document_add_value($document_pointer, 0, rand(1, 500));
		
		// add something to search on
		document_add_term($document_pointer, "bug", 1);
		
		$document_id = writabledatabase_add_document($index_pointer, $document_pointer);
	}
	
	WritableDatabase_flush($index_pointer);
	
	// now search for 'bug'
	$query = "bug";
	$query_parser = new_QueryParser();
	$query_pointer = QueryParser_parse_query($query_parser, $query);
	
	// create an enquire resource
	$enquire_pointer = new_Enquire($index_pointer);
	Enquire_set_query($enquire_pointer, $query_pointer);
	
	// order the results by the value in position zero in ascending order (none of these appear to work)
	Enquire_set_sort_by_value($enquire_pointer, 0, true);
//	Enquire_set_sort_by_value($enquire_pointer, 0, false);
//	Enquire_set_sort_by_value_then_relevance($enquire_pointer, 0, true);
//	Enquire_set_sort_by_value_then_relevance($enquire_pointer, 0, false);
	
	$result_pointer = Enquire_get_mset($enquire_pointer, 0, 10);
	$result = getResultArray($result_pointer);
	
	print_r($result);
	
	
	
	
	
	
	
	
	function getResultArray($result_pointer)
	{
		$result["total_hits"] = MSet_get_matches_estimated($result_pointer);
		
		$i = 0;
		$mset_counter = mset_begin($result_pointer);
		while (!msetiterator_equals($mset_counter, mset_end($result_pointer)))
		{
			$document_pointer = msetiterator_get_document($mset_counter);
			
			$result["result"][$i]["document_id"] = msetiterator_get_docid($mset_counter);
			
			$value_counter = document_values_begin($document_pointer);
			while (!valueiterator_equals($value_counter, document_values_end($document_pointer)))
			{
				$result["result"][$i]["values"][] = valueiterator_get_value($value_counter);
				
				valueiterator_next($value_counter);
			}
			
			$i++;
			msetiterator_next($mset_counter);
		}
		
		return $result;
	}
?>