#include <xapian.h>

#include <iostream>

using namespace std;

static Xapian::Query make_phrase(std::vector<std::string> const &terms)
{
    std::vector<Xapian::Query> qs;
    for (size_t i = 0; i < terms.size(); i++) {
        qs.push_back(Xapian::Query(terms[i], 1, i + 1));
    }
    return Xapian::Query(Xapian::Query::OP_PHRASE, qs.begin(), qs.end());
}

static Xapian::Query make_query(void)
{
    std::vector<Xapian::Query> qs;

    qs.push_back(make_phrase({ "XFgroups" }));
    qs.push_back(Xapian::Query(Xapian::Query::OP_OR,
                               make_phrase({ "XSmember", "XSchange" }),
                               make_phrase({ "XSmember", "XSchange" })));

    qs.push_back(Xapian::Query(Xapian::Query::OP_AND_NOT,
                               Xapian::Query::MatchAll,
                               Xapian::Query(Xapian::Query::OP_FILTER,
                                             Xapian::Query::MatchAll,
                                             std::string("XEP"))));

    return Xapian::Query(Xapian::Query::OP_AND, qs.begin(), qs.end());
}

int main()
try {
    Xapian::Database db("ticket838_db");
    Xapian::Query query = make_query();
    Xapian::Enquire enquire(db);
    enquire.set_query(query);
    Xapian::MSet matches = enquire.get_mset(0, 10);
}
catch (const Xapian::Error &e) {
    cout << e.get_description() << '\n';
    exit(1);
}
