#include <string>
#include <vector>
#include <list>
#include <map>
#include <set>
#include <iostream>

#include <thread>
#include <functional>
#include <typeinfo>

using namespace std;

#include "searchfacade.h"

// Comment it to use tempory Xapian::Query object
#define USE_GLOBAL_XAPIAN_QUERY_OBJECT

//////////////////////////////////////////////////////////////////////////

struct QueryCond
{
	RelativeCond cond;
	RangeCond rangeCond;
};

void ConstructQuery(const QueryCond& queryCond, Xapian::Query& query)
{
	if (!queryCond.cond.empty() || !queryCond.rangeCond.empty())
	{
		GetSearchFacadeInstance()->ConstructQuery(
			queryCond.cond, queryCond.rangeCond, query
		);
	}
}

class TestRead
{
public:
	TestRead() {}
	TestRead(const QueryCond& queryCond) : mQueryCond(queryCond) {}
	TestRead(const QueryCond& queryCond, const Xapian::Query& query)
		: mQueryCond(queryCond), mQuery(query), mQueryObjConstructed(true)
	{}
	~TestRead() {}

	virtual bool Run()
	{
		Xapian::Query query;

		if (mQueryObjConstructed)
		{
			query = mQuery;
		}
		else
		{
			ConstructQuery(mQueryCond, query);
		}

		bool ret = false;

		bool noNeedQuery = (mQueryCond.cond.empty() && query.get_length() == 0);
		std::vector<int> businessId;
		if (!noNeedQuery)
		{
			ret = GetSearchFacadeInstance()->QueryBusinessID(query, 0, 200000, businessId);
		}

		return ret;
	}

private:
	QueryCond mQueryCond;

	Xapian::Query mQuery;
	bool mQueryObjConstructed = false;
};

//////////////////////////////////////////////////////////////////////////

bool Run(const QueryCond& queryCond, const Xapian::Query& query)
{
	const int kReadThreadCount = 100;
	std::vector<std::thread> tr;
	for (int i = 0; i < kReadThreadCount; i++)
	{
#ifdef USE_GLOBAL_XAPIAN_QUERY_OBJECT
		std::shared_ptr<TestRead> r(new TestRead(queryCond, query));
#else
		std::shared_ptr<TestRead> r(new TestRead(queryCond));
#endif
		tr.emplace_back([r]() { r->Run(); });
	}

	for (auto& t : tr)
	{
		if (t.joinable())
		{
			t.join();
		}
	}

	return true;
}

//////////////////////////////////////////////////////////////////////////

int main()
{
	GetSearchFacadeInstance()->Init();
	
	// Construct query conditions & query object
	QueryCond queryCond;

	queryCond.cond["SL"] = std::vector<std::string>(1, "tunnel");
	queryCond.cond["TB"] = std::vector<std::string>(1, "1");

	RangeFieldValue rangeField;
	queryCond.rangeCond["LR"] = rangeField;

	Xapian::Query query;
	ConstructQuery(queryCond, query);

	int count = 0;
	while (true)
	{
		std::cout << "============ Running: " << ++count << " =============" << std::endl;
		Run(queryCond, query);
		std::this_thread::sleep_for(std::chrono::milliseconds(100));
	}

	GetSearchFacadeInstance()->UnInit();

	return 0;
}