#include "simpletest.h"

const std::string kDbPath = "./xapian_data";
const std::string kDocId = "007";

Xapian::WritableDatabase db;

void CreateIndex()
{
	Xapian::Document doc;
	doc.add_posting("a", 1);
	doc.add_posting("b", 1);
	doc.add_posting("c", 1);
	doc.set_data("abc");
	doc.add_boolean_term(kDocId);

	Xapian::docid innerId = db.replace_document(kDocId, doc);

	db.commit();
}

void QueryIndex()
{
	Xapian::Query terma = Xapian::Query("a");
	Xapian::Query termb = Xapian::Query("b");
	Xapian::Query termc = Xapian::Query("c");

	auto termab = Xapian::Query(Xapian::Query::OP_OR, terma, termb);
	auto termabc = Xapian::Query(Xapian::Query::OP_OR, termab, termc);

	auto query = Xapian::Query(
		Xapian::Query::OP_OR,
		Xapian::Query(Xapian::Query::OP_OR, terma, termb),
		termc
	);

	std::cout << "query: " << query.get_description() << std::endl;

	Xapian::Enquire enquire(db);
	enquire.set_query(query);
	Xapian::MSet result = enquire.get_mset(0, 10);
	std::cout << "find result count: " << result.get_matches_estimated() << std::endl;

	for (auto iter = result.begin(); iter != result.end(); ++iter)
	{
		Xapian::Document doc = iter.get_document();
		std::string data = doc.get_data();
		Xapian::weight weight = iter.get_weight();
		Xapian::percent percent = iter.get_percent();

		std::cout << "data: " << data << ", weight: " << weight << ", percent: " << percent << std::endl;
	}
}

void SimpleTest()
{
	db = Xapian::WritableDatabase(kDbPath, Xapian::DB_CREATE_OR_OPEN);

	CreateIndex();
	QueryIndex();
}