#pragma once

#include <iostream>
#include <mutex>
#include <cstdio> // For std::printf

class SafeCout
{
public:
	SafeCout() : mOut(std::cout) {}

	template<typename T>
	SafeCout& operator<<(const T& value)
	{
		std::lock_guard<std::mutex> lock(mMutex);
		mOut << value;
		return *this;
	}

	// << std::endl
	SafeCout& operator<<(std::ostream& (*func)(std::ostream&))
	{
		std::lock_guard<std::mutex> lock(mMutex);
		///*mOut = */func(mOut);
		mOut << func;
		return *this;
	}

	//template<typename Func>
	//SafeCout& operator<<(Func&& func)
	//{
	//	std::lock_guard<std::mutex> lock(mMutex);
	//	mOut = func(mOut);
	//	return *this;
	//}

	template<typename... Args>
	SafeCout& printf(const char* format, Args&&... args)
	{
		std::printf(format, std::forward<Args>(args)...);
		return *this;
	}

private:
	std::mutex mMutex;
	std::ostream& mOut;
};