#pragma once
#include <string>
#include <vector>
#include <set>
#include <map>

#include <shared_mutex>

// disable SDL checks to prevent error C4996: XXX: was declared deprecated
#pragma warning(disable: 4996)

#include "xapian.h"

#pragma comment(lib, "libxapian.lib")
#pragma comment(lib, "libgetopt.lib")
#pragma comment(lib, "zlib.lib")
#pragma comment(lib, "rpcrt4.lib")
#pragma comment(lib, "ws2_32.lib")

//////////////////////////////////////////////////////////////////////////

struct RangeFieldValue
{
	std::string start;
	std::string end;
};

typedef std::map<std::string, std::vector<std::string>> RelativeCond;
typedef std::map<std::string, RangeFieldValue> RangeCond;

//////////////////////////////////////////////////////////////////////////

class SearchFacadeIf
{
public:
	SearchFacadeIf() {}
	~SearchFacadeIf() {}

	virtual bool Init() = 0;

	virtual bool UnInit() = 0;

	virtual bool ConstructQuery(
		const RelativeCond& cond,
		const RangeCond& rangeCond,
		Xapian::Query& query) = 0;

	virtual bool QueryBusinessID(
		const Xapian::Query& query,
		const int& offSet, const int& pageSize,
		std::vector<int>& businessId,
		const std::string& fillCreator = "") = 0;
};

typedef std::shared_ptr<SearchFacadeIf> SearchFacadePtr;
SearchFacadePtr GetSearchFacadeInstance();

//////////////////////////////////////////////////////////////////////////

class SearchFacadeImpl : public SearchFacadeIf
{
	typedef std::shared_ptr<Xapian::WritableDatabase> XpWritableDataBasePtr;
	typedef std::shared_ptr<Xapian::NumberValueRangeProcessor> RangeValueProcessorPtr;

public:
	SearchFacadeImpl() {}
	~SearchFacadeImpl() {}

	virtual bool Init();

	virtual bool UnInit();

	virtual bool ConstructQuery(
		const RelativeCond& cond,
		const RangeCond& rangeCond,
		Xapian::Query& query);

	virtual bool QueryBusinessID(
		const Xapian::Query& query,
		const int& offSet, const int& pageSize,
		std::vector<int>& businessId,
		const std::string& fillCreator = "");

	bool ConstructQueryObjectTree(
		const RelativeCond& cond,
		const RangeCond& rangeCond,
		Xapian::QueryParser& queryParser,
		Xapian::Query& query,
		const std::string& fillCreator = "");

private:
	void PrepareQueryParser(Xapian::QueryParser& queryParser);

private:
	std::shared_mutex mMutex;

	XpWritableDataBasePtr mWritableDataBase;

	const std::vector<std::string> mRangeFieldName = { "CT", "LR", "MT" };
	//ַ֧Χ(ʱ䡢޸ʱ),valueΪslotͲѯ
	std::map<std::string, int> mRangeField;
};
