FROM fedora:35

ENV LANG C.UTF-8
ENV OS_NAME f35

RUN dnf install -y --nodocs \
# Base build tools
    make automake libtool cmake git-core subversion pkg-config gcc-c++ \
    wget unzip ninja-build ccache which patch gcovr xz openssh-clients \
# Cross win32 compiler
    mingw32-gcc-c++ mingw32-bzip2-static mingw32-win-iconv-static \
    mingw32-winpthreads-static mingw32-zlib-static mingw32-xz-libs-static \
  && dnf remove -y "*-doc" \
  && dnf autoremove -y \
  && dnf clean all

# Create user
RUN groupadd --gid 121 runner
RUN useradd --uid 1001 --gid 121 --create-home runner
USER runner

RUN cd $HOME \
  && pwd \
  && wget https://oligarchy.co.uk/xapian/1.4.22/xapian-core-1.4.22.tar.xz \
  && tar -xf xapian-core-1.4.22.tar.xz \
  && ls

RUN cd $HOME \
 && wget -O /home/runner/xapian.patch "https://trac.xapian.org/changeset/d2080b2feae47c9a263611e32244c6ebe7976755/git?format=diff&new=d2080b2feae47c9a263611e32244c6ebe7976755" \
 && cd xapian-core-1.4.22 \
 && cat ../xapian.patch \
 && patch -p1 < ../xapian.patch \
 && head -n50 common/safesyssocket.h

RUN cd $HOME/xapian-core-1.4.22 \
 && mingw32-configure --disable-sse --disable-backend-chert --disable-backend-remote --disable-documentation \
 && head config.log \
 && make
