/*
c++ -std=c++1z -pedantic -Wall -Wextra -O3 -lbenchmark -lbenchmark_main -I. -I./src -I../src -I.. -o benchmark-encode_length ./benchmark-encode_length.cc && ./benchmark-encode_length
*/
#include <limits>

#include "benchmark/benchmark.h"


template<class T>
std::string
encode_length_original(T len)
{
	std::string result;
	if (len < 255) {
		result += static_cast<unsigned char>(len);
	} else {
		result += '\xff';
		len -= 255;
		while (true) {
			unsigned char b = static_cast<unsigned char>(len & 0x7f);
			len >>= 7;
			if (!len) {
				result += char(b | static_cast<unsigned char>(0x80));
				break;
			}
			result += b;
		}
	}
	return result;
}

const unsigned long long x = 0xfff;
//const unsigned long long x = std::numeric_limits<unsigned long>::max() - 10;
static void BM_EncodeLength_Original(benchmark::State& state) {
	for (auto _ : state) {
		std::string s;
		for (auto i = x; i != 0; i >>= 1) {
			s += encode_length_original(i);
		}
	}
}
BENCHMARK(BM_EncodeLength_Original);


template<class T>
std::string
encode_length_optimized(T len)
{
	char result[12];
	char* end = result;
	unsigned char b = static_cast<unsigned char>(len);
	if (len >= 255) {
		b = '\xff';
		len -= 255;
		do {
			*end++ = b;
			b = static_cast<unsigned char>(len & 0x7f);
			len >>= 7;
		} while (len);
		b |= static_cast<unsigned char>(0x80);
	}
	*end++ = b;
	return std::string(result, end);
}
static void BM_EncodeLength_Optimized(benchmark::State& state) {
	for (auto _ : state) {
		std::string s;
		for (auto i = x; i != 0; i >>= 1) {
			s += encode_length_optimized(i);
		}
	}
}
BENCHMARK(BM_EncodeLength_Optimized);


//BENCHMARK_MAIN();
