/*
c++ -Iinclude -o remote-leak-test -Wl,-rpath ~+/.libs remote-leak-test.cc .libs/libxapian-1.5.so
./remote-leak-test
*/

#include <cstdio>
#include <cstdlib>
#include <iostream>

#include <unistd.h>

#include <xapian.h>

using namespace std;

#define DB "tmp.db"
#define PORT 5050
#define SERVER "localhost"

#define STRINGIZE_(X) #X
#define STRINGIZE(X) STRINGIZE_(X)

static int get_first_unused_fd() {
    int fd = dup(1);
    close(fd);
    return fd;
}

static int remote_leak() {
    try {
	auto wsdb = Xapian::Remote::open_writable(SERVER, PORT, 1000, 1000, Xapian::DB_CREATE_OR_OPEN);
    } catch (const Xapian::DatabaseLockError& exc) {
	// Expected
	return 0;
    }
    cerr << "Didn't get DatabaseLockError" << endl;
    return 1;
}

int main() {
    system("rm -rf " DB);
    system("bin/xapian-tcpsrv --writable --one-shot --port " STRINGIZE(PORT) " --interface " SERVER " " DB "&");
    sleep(1);
    Xapian::WritableDatabase wdb(DB);
    int first_unused_fd_before = get_first_unused_fd();
    if (remote_leak() != 0) {
	return 1;
    }
    int first_unused_fd_after = get_first_unused_fd();
    if (first_unused_fd_before != first_unused_fd_after) {
	cerr << "First unused fd before= " << first_unused_fd_before
	     << ", after = " << first_unused_fd_after << endl;
	return 1;
    }
    return 0;
}
