/*
c++ -std=c++14 -o tst-xapian_remote -lxapian tst-xapian_remote.cc && ./tst-xapian_remote
*/

#include <iostream>
#include <string>
#include <cstdio>
#include <cassert>
#include <thread>

#include <errno.h>
#include <unistd.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include "xapian.h"

constexpr const int port = 5000;


void fake_server_process(int sock) {
	char buf[100];
	// Send REPLY_UPDATE
	if (write(sock, "\x00" "\x2e" "\x27\x00\x05\xff\x0d\x9a\x0d\x15\x31\x6d" "8c96f317-76c4-421e-bacb-3db0e076b79e", 48) == -1) {
		perror("ERROR writing to socket");
		return;
	}
	// Receive message
	auto size = read(sock, buf, sizeof(buf));
	if (size == -1) {
		perror("ERROR reading from socket");
		return;
	}
	// Send REPLY_EXCEPTION with a fake DatabaseError
	if (write(sock, "\x01" "\x1e" "\x04" "\x0c" "Fake context" "\x0a" "Fake error" "Error", 32) == -1) {
		perror("ERROR writing to socket");
		return;
	}
	// Socket not closed on the server side
}


void fake_server() {
	int portno, clilen;
	int n, pid;

	int listen_socket = socket(AF_INET, SOCK_STREAM, 0);
	if (listen_socket == -1) {
		perror("ERROR opening socket");
		exit(1);
	}

	int optval = 1;
	if (setsockopt(listen_socket, SOL_SOCKET, SO_REUSEADDR, (char *)(&optval), sizeof(optval)) == -1) {
		perror("ERROR opening socket");
		exit(1);
	}

	struct sockaddr_in serv_addr;
	memset(&serv_addr, 0, sizeof(serv_addr));
	serv_addr.sin_family = AF_INET;
	serv_addr.sin_addr.s_addr = INADDR_ANY;
	serv_addr.sin_port = htons(port);

	if (bind(listen_socket, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) == -1) {
		perror("ERROR on binding");
		exit(1);
	}

	listen(listen_socket, 5);

	struct sockaddr_in cli_addr;
	socklen_t address_len = sizeof(cli_addr);

	while (true) {
		int sock = accept(listen_socket, (struct sockaddr *)&cli_addr, &address_len);
		if (sock != -1) {
			std::thread server(fake_server_process, sock);
			server.detach();
		}
	}
}


int main() {
	std::thread server(fake_server);

	while (true) {
		try {
			auto wsdb = Xapian::Remote::open_writable("localhost", port, 10000, 10000, Xapian::DB_CREATE_OR_OPEN);
		} catch (const Xapian::Error& exc) {
			std::cerr << exc.get_description() << std::endl;
		}
	}

	return 0;
}
