
import xapian

for i in range(40):
    database = xapian.WritableDatabase('lexicon-test',
            xapian.DB_CREATE_OR_OVERWRITE | xapian.DB_BACKEND_GLASS)
    print('Writing to', repr(database))
    with open('wordlist.txt', 'r') as f:
        print('Word data from', f.name)
        for item in f:
            indexer = xapian.TermGenerator()
            indexer.set_stemmer(xapian.Stem('en'))
            doc = xapian.Document()
            doc.set_data(item)
            indexer.set_document(doc)
            indexer.index_text(item)
            database.add_document(doc)
            del indexer
            del doc
    database.close()
