/*

  # http://trac.xapian.org/ticket/675
  # Exception in [Chert/Glass]Cursor::find_entry()

  # This script triggers an exception when using in both chert and glass databases.
  g++ -I/usr/local/include/xapian-1.3 -lxapian-1.3 the_error.cpp -o the_error

  # Chert:
  unset XAPIAN_PREFER_GLASS
  rm -rf db_the_error
  ./the_error

  # Glass:
  export XAPIAN_PREFER_GLASS=1
  rm -rf db_the_error
  ./the_error

*/

#include <xapian.h>
#include <stdio.h>
#include <string>
#include <string.h>


#define ITEMS 10
#define DATABASE "db_the_error"


int process_all(const Xapian::Database &db, int offset, int limit, bool datas, bool values) {
	Xapian::Enquire enq(db);
	enq.set_query(Xapian::Query(""));
	Xapian::MSet m = enq.get_mset(offset, limit);
	Xapian::MSetIterator mi(m.begin());
	int i = 1;
	for ( ; mi != m.end(); mi++, i++) {
		Xapian::docid docid = *mi;
		Xapian::Document document = mi.get_document();
		std::string data, value;
		if (datas) {
			data = document.get_data();
		}
		if (values) {
			value = document.get_value(0);
		}
		// printf("docid: %u, value: %s\n", docid, value.c_str());
	}
	return i;
}


void index(Xapian::WritableDatabase &wdb, Xapian::doccount next_id) {
	Xapian::Document doc;
	std::string id = std::to_string(next_id);
	std::string doc_id = "Q" + id;
	doc.add_value(0, id);
	/* When using valgrind and glass, uncommenting the following line, triggers a different problem:
	   "Signal 11 being dropped from thread 0's queue being dropped" */
	// doc.set_data(doc_id);
	doc.add_boolean_term(doc_id);
	wdb.replace_document(doc_id, doc);
	// printf("indexed: %s\n", doc_id.c_str());
}


void run() {
	Xapian::WritableDatabase wdb = Xapian::WritableDatabase(DATABASE, Xapian::DB_CREATE_OR_OPEN);
	Xapian::Database db = Xapian::Database(DATABASE);

	Xapian::doccount free_id = db.get_doccount();

	int offset = free_id > (ITEMS * 2) ? free_id - (ITEMS * 2) : 0;
	int limit = offset + (ITEMS * 2);

	/* If the next line is commented, the exception isn't thrown; a read is needed before the reopen() */
	process_all(db, offset, limit, false, true);

	for (Xapian::doccount next_id = free_id; next_id <= free_id + ITEMS; next_id++) {
		index(wdb, next_id);
	}
	wdb.commit();

	db.reopen();

	/* The next line will throw the exception on get_value()! */
	process_all(db, offset, limit, false, true);
}

int main() {
	for (int i = 0; i < 100; i++) {
		run();
	}
}

/*

CHERT backtace (more often)
===========================

All documents after reopen():
Process 17442 stopped
* thread #1: tid = 0x1add6, 0x00007fff927301b5 libsystem_platform.dylib`_platform_memmove$VARIANT$Unknown + 533, queue = 'com.apple.main-thread', stop reason = EXC_BAD_ACCESS (code=1, address=0x1007ffff3)
    frame #0: 0x00007fff927301b5 libsystem_platform.dylib`_platform_memmove$VARIANT$Unknown + 533
libsystem_platform.dylib`_platform_memmove$VARIANT$Unknown:
->  0x7fff927301b5 <+533>: vmovups -0x40(%rsi), %ymm2
    0x7fff927301ba <+538>: subq   $0x40, %rsi
    0x7fff927301be <+542>: subq   $0x40, %rdx
    0x7fff927301c2 <+546>: ja     0x7fff927301a2            ; <+514>
(lldb) bt
* thread #1: tid = 0x1add6, 0x00007fff927301b5 libsystem_platform.dylib`_platform_memmove$VARIANT$Unknown + 533, queue = 'com.apple.main-thread', stop reason = EXC_BAD_ACCESS (code=1, address=0x1007ffff3)
  * frame #0: 0x00007fff927301b5 libsystem_platform.dylib`_platform_memmove$VARIANT$Unknown + 533
    frame #1: 0x00007fff9bd7ee8d libc++.1.dylib`std::__1::basic_string<char, std::__1::char_traits<char>, std::__1::allocator<char> >::__grow_by_and_replace(unsigned long, unsigned long, unsigned long, unsigned long, unsigned long, unsigned long, char const*) + 193
    frame #2: 0x00007fff9bd7e581 libc++.1.dylib`std::__1::basic_string<char, std::__1::char_traits<char>, std::__1::allocator<char> >::assign(char const*, unsigned long) + 113
    frame #3: 0x000000010005741c libxapian-1.3.3.dylib`ChertCursor::find_entry(std::__1::basic_string<char, std::__1::char_traits<char>, std::__1::allocator<char> > const&) + 588
    frame #4: 0x0000000100085eed libxapian-1.3.3.dylib`ChertValueManager::get_chunk_containing_did(unsigned int, unsigned int, std::__1::basic_string<char, std::__1::char_traits<char>, std::__1::allocator<char> >&) const + 301
    frame #5: 0x000000010008812e libxapian-1.3.3.dylib`ChertValueManager::get_value(unsigned int, unsigned int) const + 174
    frame #6: 0x000000010006d3ec libxapian-1.3.3.dylib`ChertDocument::do_get_value(unsigned int) const + 28
    frame #7: 0x00000001000161c8 libxapian-1.3.3.dylib`Xapian::Document::get_value(unsigned int) const + 104
    frame #8: 0x0000000100001861 the_error`process_all(Xapian::Database const&, int, int) + 561
    frame #9: 0x00000001000021a1 the_error`main + 881
    frame #10: 0x00007fff9288f5c9 libdyld.dylib`start + 1
    frame #11: 0x00007fff9288f5c9 libdyld.dylib`start + 1


GLASS backtrace
===============

Process 17306 stopped
* thread #1: tid = 0x1ab68, 0x00000001000c0fe7 libxapian-1.3.3.dylib`GlassTable::find_in_block(unsigned char const*, Glass::Key, bool, int) + 39, queue = 'com.apple.main-thread', stop reason = EXC_BAD_ACCESS (code=1, address=0x9)
    frame #0: 0x00000001000c0fe7 libxapian-1.3.3.dylib`GlassTable::find_in_block(unsigned char const*, Glass::Key, bool, int) + 39
libxapian-1.3.3.dylib`GlassTable::find_in_block:
->  0x1000c0fe7 <+39>: movzbl 0x9(%rsi), %eax
    0x1000c0feb <+43>: shll   $0x8, %eax
    0x1000c0fee <+46>: movzbl 0xa(%rsi), %r13d
    0x1000c0ff3 <+51>: orl    %eax, %r13d
(lldb) bt
* thread #1: tid = 0x1ab68, 0x00000001000c0fe7 libxapian-1.3.3.dylib`GlassTable::find_in_block(unsigned char const*, Glass::Key, bool, int) + 39, queue = 'com.apple.main-thread', stop reason = EXC_BAD_ACCESS (code=1, address=0x9)
  * frame #0: 0x00000001000c0fe7 libxapian-1.3.3.dylib`GlassTable::find_in_block(unsigned char const*, Glass::Key, bool, int) + 39
    frame #1: 0x00000001000c12ff libxapian-1.3.3.dylib`GlassTable::find(Glass::Cursor*) const + 111
    frame #2: 0x000000010009ac54 libxapian-1.3.3.dylib`GlassCursor::find_entry(std::__1::basic_string<char, std::__1::char_traits<char>, std::__1::allocator<char> > const&) + 164
    frame #3: 0x00000001000c8f8d libxapian-1.3.3.dylib`GlassValueManager::get_chunk_containing_did(unsigned int, unsigned int, std::__1::basic_string<char, std::__1::char_traits<char>, std::__1::allocator<char> >&) const + 301
    frame #4: 0x00000001000cb1ce libxapian-1.3.3.dylib`GlassValueManager::get_value(unsigned int, unsigned int) const + 174
    frame #5: 0x00000001000aff8c libxapian-1.3.3.dylib`GlassDocument::do_get_value(unsigned int) const + 28
    frame #6: 0x00000001000161c8 libxapian-1.3.3.dylib`Xapian::Document::get_value(unsigned int) const + 104
    frame #7: 0x0000000100001861 the_error`process_all(Xapian::Database const&, int, int) + 561
    frame #8: 0x00000001000021a1 the_error`main + 881
    frame #9: 0x00007fff9288f5c9 libdyld.dylib`start + 1
    frame #10: 0x00007fff9288f5c9 libdyld.dylib`start + 1
*/
