/*

  # http://trac.xapian.org/ticket/654
  # Getting EOF when using get_data() in a remote database

  # This script triggers an exception when using in both chert and glass databases.
  g++ -I/usr/local/include/xapian-1.3 -lxapian-1.3 the_bug.cpp -o the_bug

  # Chert:
  unset XAPIAN_PREFER_GLASS
  rm -rf db_the_bug
  xapian-tcpsrv-1.3 --timeout=0 --port=8890 --writable db_the_bug &
  ./the_bug

  # Glass:
  export XAPIAN_PREFER_GLASS=1
  rm -rf db_the_bug
  xapian-tcpsrv-1.3 --timeout=0 --port=8890 --writable db_the_bug &
  ./the_bug

*/

#include <xapian.h>
#include <stdio.h>
#include <string>
#include <string.h>


#define ITEMS 10
#define DATABASE "db_the_bug"


int process_all(const Xapian::Database &db, int offset, int limit, bool datas, bool values) {
	Xapian::Enquire enq(db);
	enq.set_query(Xapian::Query(""));
	Xapian::MSet m = enq.get_mset(offset, limit);
	Xapian::MSetIterator mi(m.begin());
	int i = 1;
	for ( ; mi != m.end(); mi++, i++) {
		Xapian::docid docid = *mi;
		Xapian::Document document = mi.get_document();
		std::string data, value;
		if (datas) {
			data = document.get_data();
		}
		if (values) {
			value = document.get_value(0);
		}
		printf("docid: %u, value: %s, data: %s\n", docid, value.c_str(), data.c_str());
	}
	return i;
}


void index(Xapian::WritableDatabase &wdb, Xapian::doccount next_id) {
	Xapian::Document doc;
	std::string id = std::to_string(next_id);
	std::string doc_id = "Q" + id;
	doc.add_value(0, id);
	doc.set_data(doc_id);
	doc.add_boolean_term(doc_id);
	wdb.replace_document(doc_id, doc);
	printf("indexed: %s\n", doc_id.c_str());
}


void run() {
	Xapian::WritableDatabase wdb = Xapian::Remote::open_writable("localhost", 8890, 0);
	Xapian::Database db = Xapian::Remote::open("localhost", 8890, 0);

	Xapian::doccount free_id = db.get_doccount();

	int offset = free_id > (ITEMS * 2) ? free_id - (ITEMS * 2) : 0;
	int limit = offset + (ITEMS * 2);

	/* If the next line is commented, the exception isn't thrown; a read is needed before the reopen() */
	process_all(db, offset, limit, true, false);

	for (Xapian::doccount next_id = free_id; next_id <= free_id + ITEMS; next_id++) {
		index(wdb, next_id);
	}
	wdb.commit();

	db.reopen();

	/* The next line will throw the exception on get_value()! */
	process_all(db, offset, limit, true, false);
}

int main() {
	for (int i = 0; i < 100; i++) {
		run();
	}
}
