#!/usr/bin/env python

# In a clean directory, run:
# xapian-tcpsrv --timeout=0 --port=8900 --writable bug

import xapian


def test():
    def replace_document(i):
        slots = {
            'id': 1973816463L,
            'date': 4132511615L,
            'color': 1271831549L,
            'size': 962337316L,
        }
        doc = xapian.Document()
        doc.set_data('"DATA %s"' % i)
        doc.add_value(slots['id'], 'doc%s' % i)
        doc.add_boolean_term('Qdoc%s' % i)
        wd.replace_document('Qdoc%s' % i, doc)  # Seems this must be a replace_document() for it to fail
        wd.commit()

    wd = xapian.remote_open_writable('localhost', 8900, 0)
    rd = xapian.remote_open('localhost', 8900, 0)
    try:
        wd.keep_alive()
        rd.keep_alive()

        # WRITE END
        replace_document(1)
        # replace_document(2)
        # replace_document(3)

        # READ END
        rd.reopen()

        print '1:', rd.get_document(1).get_data()

        # WRITE END
        replace_document(2)

        # READ END
        rd.reopen()

        print '2:', rd.get_document(1).get_data()   # This will throw EOF (most of the times)

    finally:
        rd.close()
        wd.close()


if __name__ == '__main__':
    test()
