#!/usr/bin/python
import os                                                             
import simplejson as json                                             
import xapian as x                                                    
import shutil                                                         
import gc                                                             
                                                                      
def make_db(path, num_docs=100000):                                   
    try:                                                              
        shutil.rmtree(path)                                           
    except OSError, e:                                                
        if e.errno != 2:                                              
            raise                                                     
                                                                      
    db = x.WritableDatabase(path, x.DB_CREATE)                        
    for i in xrange(1, num_docs):                                     
        doc = x.Document()                                            
        doc.set_data(json.dumps({ 'id': i, 'enabled': True }))        
        doc.add_term('XTYPA')                                         
        db.add_document(doc)                                          
    return db                                                         
                                                                      
def run_query(db, num_docs=100000):                                   
    e = x.Enquire(db)                                                 
    e.set_query(x.Query('XTYPA'))                                     
    m = e.get_mset(0, num_docs, True, None)                           
                                                                      
    # Store the MSetItem's data, which causes a memory leak            
    data = []                                                         
    for i in m:                                                       
        data.append({ 'data': i.document.get_data(), 'id': i.docid, })
                                                                      
    # Make sure I'm not crazy                                         
    del num_docs, db, i, e, m, data                                   
    gc.collect()                                                      
                                                                      
def main():                                                           
    # print the PID to monitor                                        
    print 'PID to monitor: {}'.format(os.getpid())                    
                                                                      
    db = make_db('ticket637.db')                                      
    raw_input("database is done, ready?")                             
                                                                      
    gc.collect()
    gc.collect()
    gc.collect()
    gc.collect()
    print "num objects before = ", len(gc.get_objects())
    run_query(db, 100000)                                             
    print "num objects after = ", len(gc.get_objects())
    raw_input('done?')                                                
                                                                      
if __name__ == '__main__':                                            
    main()
