#include <xapian.h>
#include <iostream>
#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

using namespace std;

static void get_memory() {
    static pid_t pid = getpid();
    char buf[80];
    sprintf(buf, "ps -p %d -o rss -o vsz | tail -1", pid);
    system(buf);
}

static void test(const char * name, bool get_data) {
    cout << "version: " << Xapian::version_string() << endl;
    Xapian::Database database(name);
    Xapian::Enquire enquiry(database);
    enquiry.set_query(Xapian::Query::MatchAll);
    Xapian::MSet matches = enquiry.get_mset(0, database.get_doccount());
    Xapian::doccount total = matches.get_matches_estimated();
    cout << "matches: " << total << "  ";
    get_memory();

    for (Xapian::doccount i = 0; i < total; ++i) {
        if (get_data)
	    matches[i].get_document();
        if (i % 100 == 99) {
	    cout << "read: " << i + 1 << "  " << flush;
            get_memory();
	}
    }
}
 
int main(int, char **argv) {
    bool get_data = true;
    ++argv;
    if (*argv && strcmp(*argv, "-d") == 0) {
	get_data = false;
	++argv;
    }
    test(*argv, get_data);
}
