#!/usr/bin/env python

from xapian import Document, Query, WritableDatabase, Enquire, DB_CREATE_OR_OPEN

def search(db, query):
    print("Query: %s" % query)

    enquire = Enquire(db)
    enquire.set_query(query)

    for m in enquire.get_mset(0, 10):
        print '%s - %s - %s' % (m.docid, m.percent, ', '.join(t.term for t in m.document))

OWNER = 'Ome'

db = WritableDatabase('/tmp/test.db', DB_CREATE_OR_OPEN)

for t in ['cold', 'kids']:
    doc = Document()

    doc.add_term(t)
    doc.add_boolean_term(OWNER)

    db.add_document(doc)

term_q          = Query(Query.OP_OR, ['cold', 'kids'])
owner_q         = Query(OWNER)
filtered_term_q = Query(Query.OP_FILTER, term_q, owner_q)

search(db, term_q)
search(db, filtered_term_q)

db.close()
