import xapian

class TestMatchDecider(xapian.MatchDecider):
    def __init__(self):
        super(TestMatchDecider, self).__init__()

    def __call__(self, doc):
        return True

if __name__ == '__main__':
    import gc
    import xapian
    import weakref
    db = xapian.WritableDatabase('test', xapian.DB_CREATE_OR_OPEN)
    doc = xapian.Document()
    doc.set_data('test')
    db.replace_document(1, doc)
    enq = xapian.Enquire(db)
    enq.set_query(xapian.Query.MatchAll)
    print "new dec (decider)"
    dec = TestMatchDecider()
    decref = weakref.ref(dec)
    print "decref:", decref()
    print "removing dec"
    del dec
    print "decref:", decref()
    print "new dec"
    dec = TestMatchDecider()
    decref = weakref.ref(dec)
    print "decref:", decref()
    print "decref referrer count:", len(gc.get_referrers(decref()))
    print "type of decref referrer 1:", type(gc.get_referrers(decref())[0])
    print "decref referrer == locals()?", gc.get_referrers(decref())[0] == locals()
    mset = enq.get_mset(0, 1, 1, None, dec)
    print "removing local variables and garbage collecting"
    del db, doc, enq, dec
    gc.collect()
    print "decref:", decref()
    print "decref referrer count:", len(gc.get_referrers(decref()))
    print "decref referrers:", gc.get_referrers(decref())
    print "type of decref referrer 1", type(gc.get_referrers(decref())[0])
    print "referrers of decref referrer 1:", gc.get_referrers(gc.get_referrers(decref())[0])
    #import pdb
    #pdb.set_trace()

