<?php
require('xapian.php'); // adjust the path to xapian.php

echo 'PHP version ', PHP_VERSION, ', Xapian version ', Xapian::version_string(), "\n\n";

// Create a dummy in-memory database
$db=Xapian::inmemory_open();
$doc = new XapianDocument();
echo 'Creating a new db containing one document with terms : ';
foreach(array('xapian', 'tester','testable','user','query') as $term)
{
    $doc->add_term(utf8_encode($term));
    echo $term, ', ';
}
echo "\n\n";
$db->add_document($doc);

// Setup QueryParser
$queryParser = new XapianQueryParser();
$flags = XapianQueryParser::FLAG_WILDCARD;
$queryParser->set_database($db);

// Tests
if (Xapian::version_string() >= '1.2.0') // take OP_SYNONYM into account
{
    $tests = array  // 'query' => 'expected result'
    (
        'test* xapian' => 'Xapian::Query(((testable:(pos=1) SYNONYM tester:(pos=1)) OR xapian:(pos=2)))',
        'xapian test*' => 'Xapian::Query((xapian:(pos=1) OR (testable:(pos=2) SYNONYM tester:(pos=2))))',

        'test* xapian user' => 'Xapian::Query(((testable:(pos=1) SYNONYM tester:(pos=1)) OR xapian:(pos=2) OR user:(pos=3)))',
        'xapian user test*' => 'Xapian::Query((xapian:(pos=1) OR user:(pos=2) OR (testable:(pos=3) SYNONYM tester:(pos=3))))',
        'xapian test* user' => 'Xapian::Query((xapian:(pos=1) OR (testable:(pos=2) SYNONYM tester:(pos=2)) OR user:(pos=3)))',

        'xapian query test* user' => 'Xapian::Query((xapian:(pos=1) OR query:(pos=2) OR (testable:(pos=3) SYNONYM tester:(pos=3)) OR user:(pos=4)))',
        'xapian que* test* user' => 'Xapian::Query((xapian:(pos=1) OR query:(pos=2) OR (testable:(pos=3) SYNONYM tester:(pos=3)) OR user:(pos=4)))',

        'xapian que* user test*' => 'Xapian::Query((xapian:(pos=1) OR query:(pos=2) OR user:(pos=3) OR (testable:(pos=4) SYNONYM tester:(pos=4))))',
    );
}
else
{
    $tests = array  // 'query' => 'expected result'
    (
        'test* xapian' => 'Xapian::Query((testable:(pos=1) OR tester:(pos=1) OR xapian:(pos=2)))',
        'xapian test*' => 'Xapian::Query((xapian:(pos=1) OR testable:(pos=2) OR tester:(pos=2)))',

        'test* xapian user' => 'Xapian::Query((testable:(pos=1) OR tester:(pos=1) OR xapian:(pos=2) OR user:(pos=3)))',
        'xapian user test*' => 'Xapian::Query((xapian:(pos=1) OR user:(pos=2) OR testable:(pos=3) OR tester:(pos=3)))',
        'xapian test* user' => 'Xapian::Query((xapian:(pos=1) OR testable:(pos=2) OR tester:(pos=2) OR user:(pos=3)))',

        'xapian query test* user' => 'Xapian::Query((xapian:(pos=1) OR query:(pos=2) OR testable:(pos=3) OR tester:(pos=3) OR user:(pos=4)))',
        'xapian que* test* user' => 'Xapian::Query((xapian:(pos=1) OR query:(pos=2) OR testable:(pos=3) OR tester:(pos=3) OR user:(pos=4)))',

        'xapian que* user test*' => 'Xapian::Query((xapian:(pos=1) OR query:(pos=2) OR user:(pos=3) OR testable:(pos=4) OR tester:(pos=4)))',
    );
}

foreach($tests as $test=>$expected)
{
    $query = $queryParser->parse_query(utf8_encode($test), $flags);
    echo 'query:  ', $test, "\n";
    $result = $query->get_description();
    echo 'result: ', $result, "\n";
    if ($result === $expected)
    {
        echo "OK.\n";
    }
    else
    {
        echo 'expect: ', $expected, "\n";
        echo "FAILS.\n";
    }
    echo "\n";
}