#!/usr/bin/python

def to_dms(angle):
    m = 60 * (angle % 1)
    s = 60 * (m % 1)
    return (int(angle), int(m), s)

def encode(lat, long):
    if lat < -90 or lat > 90:
        raise ValueError("latitude out of range")
    if lat == -90:
        # South Pole special case.
        return b''
    if lat == 90:
        # North Pole special case.
        return b'\xff\xff'
    # Wrap longitude to range [0,360).
    while long >= 360:
        long -= 360
    while long < 0:
        long += 360
    lat = to_dms(lat + 90)
    long = to_dms(long)
    result = bytearray()
    dd = lat[0] * 360 + long[0]
    result.append(dd >> 8)
    result.append(dd & 255)
    m1 = (lat[1] // 4) << 4 | (long[1] // 4)
    result.append(m1)
    ms = (lat[1] % 4) << 6 | (long[1] % 4) << 4
    ms |= int(lat[2] // 15) << 2 | int(long[2] // 15)
    result.append(ms)
    s2 = int(lat[2] % 15) << 4 | int(long[2] % 15)
    result.append(s2)
    s3 = (int(lat[2] / 15) & 0x0f) << 4 | (int(long[2] / 15) & 0x0f);
    result.append(s3)

    # Remove trailing zeros.
    while len(result) and result[-1] == 0:
        result.pop()
    return result

def decode(value):
    if len(value) == 0:
        return (-90.0, 0.0)
    if value == b'\xff\xff':
        return (90.0, 0.0)
    if len(value) == 1:
        dd = 0
    else:
        dd = value[1]
    dd |= (value[0] << 8)
    lat = dd // 360;
    long = dd % 360;
    if len(value) > 2:
        m1 = value[2]
        lat_m = (m1 >> 4) * 4
        long_m = (m1 & 15) * 4
        if len(value) > 3:
            ms = value[3]
            lat_m += ms >> 6
            long_m += (ms >> 4) & 3
            lat_s = ((ms >> 2) & 3) * 15
            long_s = (ms & 3) * 15
            if len(value) > 4:
                s2 = value[4]
                lat_s += s2 >> 4
                long_s += s2 & 15
                if len(value) > 5:
                    s3 = value[5]
                    lat_s += ((s3 >> 4) + 0.5) / 16.0
                    long_s += ((s3 & 15) + 0.5) / 16.0
                else:
                    lat_s += 0.5
                    long_s += 0.5
            else:
                lat_s += 7.5
                long_s += 7.5
            lat_m += lat_s / 60.0
            long_m += long_s / 60.0
        else:
            lat_m += 2
            long_m += 2
        lat += lat_m / 60.0
        long += long_m / 60.0
    else:
        lat += 0.5
        long += 0.5
    return (lat - 90, long)
