# -*- coding: utf-8 -*-

import sys
sys.path.insert(0, 'build/lib.linux-x86_64-2.6')
sys.path.insert(0, 'build/lib.linux-i386-2.6')
sys.path.insert(0, 'build/lib.linux-i586-2.6')
sys.path.insert(0, 'build/lib.linux-i686-2.6')

def main():
    import xapian
    from xapian_hunspell_stemmer import HunspellStem

    query_parser = xapian.QueryParser()
    stop = xapian.SimpleStopper()
    stop.add('of')
    stop.add('the')
    query_parser.set_stopper(stop)
    stem = HunspellStem('en')
#    stem = xapian.Stem('en')
#    print stem(u'gold')
    query_parser.set_stemmer(stem)
    query_parser.set_stemming_strategy(xapian.QueryParser.STEM_ALL)
    for w in query_parser.parse_query("I'm afraid your patches won't actually work! But it does!"):
        print w,
    print

    doc = xapian.Document()
    generator = xapian.TermGenerator()
    generator.set_document(doc)
    generator.set_flags(xapian.TermGenerator.FLAG_SPELLING)
    generator.set_stemmer(stem)

if __name__ == '__main__':
    main()
