/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * main.cc
 * Copyright (C) Evgeny Sizikov 2010 <esizikov@gmail.com>
 * 
 * test_xapian_stem is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * test_xapian_stem is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <iostream>
#include <algorithm>

#include <xapian/queryparser.h>
#include "xapian_hunspell_stemmer.h"

// a search query in Russian as an example of non-ASCII characters in UTF-8
const std::string search_query = "платья из золота на продажу";

int main()
{
	// get a stemmer instance
	Xapian::HunspellStem stem("ru");

	// get a query parser instance
	Xapian::QueryParser qp;

	// apply our stemmer
	qp.set_stemmer(stem);
	// set stemming strategy to return only stemmed terms
	qp.set_stemming_strategy(Xapian::QueryParser::STEM_ALL);

	// parse the query using our stemmer
	Xapian::Query query = qp.parse_query(search_query);

	// output original search query
	std::cout << search_query << "\n";
	
    // output parsed query terms
    std::copy(
        query.get_terms_begin(),
        query.get_terms_end(),
        std::ostream_iterator<std::string >(std::cout, " "));
	std::cout << std::endl;

	return 0;
}
