# msg2txt.py:
#
# Converts & output Outlook .MSG files to Text(STDOUT).
#
# Copyright 2009 Frank J Bruzzaniti
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
# USA

import sys, os, email, subprocess
# added extra import because of bug using freeze.py
import email.iterators

# Check to see argument is givin
if len(sys.argv) != 2:
  print 'No file specified\n'
  sys.exit()

# Create bitbucket for errors
devnull = open(os.devnull, "w")

# Run perl script
p = subprocess.Popen(['perl','-MEmail::Outlook::Message','-e','print new Email::Outlook::Message($ARGV[0])->to_email_mime->as_string',sys.argv[1]],stdout=subprocess.PIPE,stderr=devnull)

devnull.close()

# feed mime created by perl script to msg via email.message_from_string()
msg = email.message_from_string(p.stdout.read())

# For each section that iis NOT an attachment print to stdout
for part in msg.walk():
  strContent =  part.get_content_type()
  if strContent[0:5] == 'text/':
    print part.get_payload(decode=True)
        




 
