#!/bin/sh

# Document and document path variables
DIR=$(pwd)
DOC=$DIR/$1

# Quietly kill any copies of soffice still hanging around
killall -q soffice.bin

# Run macro                                                                                
soffice -invisible -norecover -headless "macro:///Standard.Module1.SaveAsHTML($DOC)"

# Construct name variable matching newly created file
TEMPFILE=`echo $DOC |  cut -d'.' -f1`.html

# Since soffice sometimes exits early, sleep until temp HTML file is created
while [ ! -e $TEMPFILE ]; do
sleep 1
done

# Output HTML
cat *.html


