import xappy

prices = ['11.95', '14.50', '60.00'] 

iconn = xappy.IndexerConnection('db1')
iconn.add_field_action('price', xappy.FieldActions.FACET, type='float')

for index, price in enumerate(prices):
    doc = xappy.UnprocessedDocument(id=str(index))
    doc.fields.append(xappy.Field('price', price))
    iconn.replace(doc)

del iconn

sconn = xappy.SearchConnection('db1')
results = sconn.search(sconn.query_all(), 1, 1000, getfacets=True, allowfacets=['price'])

s = results.get_suggested_facets(maxfacets=1, required_facets=['price'], 
        desired_num_of_categories=1000)

# this should print 3 facets
print s[0][1]
