#!/usr/bin/env python

import xapian
import os
import random

os.environ['XAPIAN_FLUSH_THRESHOLD'] = "100000000"

db = xapian.WritableDatabase('/tmp/test_index', xapian.DB_CREATE_OR_OPEN)

some_data = 'one two three four five six seven eight nine ten'.split()

for id in xrange(500000):
    print id

    if id % 50000 == 0:
        print "flushing index"
        db.flush()

    value = ''
    for num in xrange(10):
        value += chr(65 + random.randint(0, 25))

    doc = xapian.Document()
    doc.add_term("Q%d" % id)
    doc.add_term("XFOO" + some_data[random.randint(0, 9)])
    doc.add_term("XBAR" + some_data[random.randint(0, 1)])

    if db.term_exists("Q%d" % id):
        db.replace_document("Q%d" % id, doc)
    else:
        db.add_document(doc)
