
import threading
import xapian
import time

class context(object):
    def __init__(self):
        self.mutex = threading.Lock()
        self.opencount = 0
        self.threadcount = 0
        self.logitems = []
        self.failed = False

    def get_threadnum(self):
        self.threadcount += 1
        return self.threadcount

    def inccount(self):
        self.mutex.acquire()
        try:
            self.opencount += 1
            result = self.opencount
        finally:
            self.mutex.release()
        return result

    def deccount(self):
        self.mutex.acquire()
        try:
            self.opencount -= 1
            result = self.opencount
        finally:
            self.mutex.release()
        return result

    def log(self, msg):
        self.logitems.append(msg)

    def fail(self):
        self.failed = True

class test(threading.Thread):
    def __init__(self, context, **kwargs):
        threading.Thread.__init__(self, **kwargs)
        self.context = context
        self.threadnum = context.get_threadnum()

    def run(self):
        time.sleep(0.01)
        self.context.log("opening %d" % self.threadnum)
        try:
            db = xapian.WritableDatabase('testdb', xapian.DB_CREATE_OR_OPEN)
        except:
            self.context.log("already open %d" % self.threadnum)
            return

        self.context.log("opened %d" % self.threadnum)
        open = self.context.inccount()
        if open != 1:
            self.context.log("FAIL: simultanous open from thread %d" % self.threadnum)
            self.context.fail()
            raise RuntimeError("Opened %d databases simultaneously" % open)
        time.sleep(0.01)
        self.context.deccount() # Might be too soon, but we'll never overcount
        self.context.log("closing %d" % self.threadnum)
        del db
        self.context.log("closed %d" % self.threadnum)

def runtest():
    c=context()
    threads=[]
    for num in xrange(10):
        threads.append(test(c))

    for thread in threads:
        thread.start()

    for thread in threads:
        thread.join()

    if c.failed:
        print '\n'.join(c.logitems)
    else:
        print "passed"
    return c.failed

for i in xrange(100):
    f = runtest()
    if f:
        break
