#!/usr/bin/env python

import os
import xapian

path="foo1"
base_extn=".baseB"

db = xapian.WritableDatabase(path, xapian.DB_CREATE_OR_OVERWRITE)
doc = xapian.Document()
# Database has full set of baseA, no baseB

db.add_document(doc)
db.flush()

# Database has full set of baseB, old baseA

db.add_document(doc)
db.flush()

# Database has full set of baseA, old baseB
dbr = xapian.Database(path);
print dbr.get_doccount()

# Simulate a transaction starting, some of the baseB getting removed,
# but then the transaction fails.
os.unlink(os.path.join(path, 'record' + base_extn))
os.unlink(os.path.join(path, 'termlist' + base_extn))

# Database has full set of baseA, some old baseB
dbr = xapian.Database(path);
print dbr.get_doccount()

db.add_document(doc)
db.flush()

# Database has full set of baseB, old baseA

dbr = xapian.Database(path);
print dbr.get_doccount()

db.add_document(doc)
db.flush()

dbr = xapian.Database(path);
print dbr.get_doccount()
